package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.Hostname
import scala.jdk.CollectionConverters._
final case class DnsServiceDiscovery(
    hostname: Hostname,
    ipPreference: Optional[zio.aws.appmesh.model.IpPreference] =
      Optional.Absent,
    responseType: Optional[zio.aws.appmesh.model.DnsResponseType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery = {
    import DnsServiceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery
      .builder()
      .hostname(Hostname.unwrap(hostname): java.lang.String)
      .optionallyWith(ipPreference.map(value => value.unwrap))(_.ipPreference)
      .optionallyWith(responseType.map(value => value.unwrap))(_.responseType)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly =
    zio.aws.appmesh.model.DnsServiceDiscovery.wrap(buildAwsValue())
}
object DnsServiceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DnsServiceDiscovery =
      zio.aws.appmesh.model.DnsServiceDiscovery(
        hostname,
        ipPreference.map(value => value),
        responseType.map(value => value)
      )
    def hostname: Hostname
    def ipPreference: Optional[zio.aws.appmesh.model.IpPreference]
    def responseType: Optional[zio.aws.appmesh.model.DnsResponseType]
    def getHostname: ZIO[Any, Nothing, Hostname] = ZIO.succeed(hostname)
    def getIpPreference
        : ZIO[Any, AwsError, zio.aws.appmesh.model.IpPreference] =
      AwsError.unwrapOptionField("ipPreference", ipPreference)
    def getResponseType
        : ZIO[Any, AwsError, zio.aws.appmesh.model.DnsResponseType] =
      AwsError.unwrapOptionField("responseType", responseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery
  ) extends zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly {
    override val hostname: Hostname =
      zio.aws.appmesh.model.primitives.Hostname(impl.hostname())
    override val ipPreference: Optional[zio.aws.appmesh.model.IpPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPreference())
        .map(value => zio.aws.appmesh.model.IpPreference.wrap(value))
    override val responseType: Optional[zio.aws.appmesh.model.DnsResponseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseType())
        .map(value => zio.aws.appmesh.model.DnsResponseType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery
  ): zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly = new Wrapper(impl)
}
