package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.DurationValue
import scala.jdk.CollectionConverters._
final case class Duration(
    unit: Optional[zio.aws.appmesh.model.DurationUnit] = Optional.Absent,
    value: Optional[DurationValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.Duration = {
    import Duration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.Duration
      .builder()
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        value.map(value => DurationValue.unwrap(value): java.lang.Long)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.Duration.ReadOnly =
    zio.aws.appmesh.model.Duration.wrap(buildAwsValue())
}
object Duration {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.Duration] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.Duration = zio.aws.appmesh.model
      .Duration(unit.map(value => value), value.map(value => value))
    def unit: Optional[zio.aws.appmesh.model.DurationUnit]
    def value: Optional[DurationValue]
    def getUnit: ZIO[Any, AwsError, zio.aws.appmesh.model.DurationUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, DurationValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.Duration
  ) extends zio.aws.appmesh.model.Duration.ReadOnly {
    override val unit: Optional[zio.aws.appmesh.model.DurationUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.appmesh.model.DurationUnit.wrap(value))
    override val value: Optional[DurationValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.appmesh.model.primitives.DurationValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.Duration
  ): zio.aws.appmesh.model.Duration.ReadOnly = new Wrapper(impl)
}
