package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HttpRouteAction(
    weightedTargets: Iterable[zio.aws.appmesh.model.WeightedTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRouteAction = {
    import HttpRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRouteAction
      .builder()
      .weightedTargets(weightedTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRouteAction.ReadOnly =
    zio.aws.appmesh.model.HttpRouteAction.wrap(buildAwsValue())
}
object HttpRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRouteAction =
      zio.aws.appmesh.model.HttpRouteAction(weightedTargets.map { item =>
        item.asEditable
      })
    def weightedTargets: List[zio.aws.appmesh.model.WeightedTarget.ReadOnly]
    def getWeightedTargets: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.WeightedTarget.ReadOnly
    ]] = ZIO.succeed(weightedTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteAction
  ) extends zio.aws.appmesh.model.HttpRouteAction.ReadOnly {
    override val weightedTargets
        : List[zio.aws.appmesh.model.WeightedTarget.ReadOnly] = impl
      .weightedTargets()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.WeightedTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteAction
  ): zio.aws.appmesh.model.HttpRouteAction.ReadOnly = new Wrapper(impl)
}
