package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.ListenerPort
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HttpRouteMatch(
    headers: Optional[Iterable[zio.aws.appmesh.model.HttpRouteHeader]] =
      Optional.Absent,
    method: Optional[zio.aws.appmesh.model.HttpMethod] = Optional.Absent,
    path: Optional[zio.aws.appmesh.model.HttpPathMatch] = Optional.Absent,
    port: Optional[ListenerPort] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent,
    queryParameters: Optional[
      Iterable[zio.aws.appmesh.model.HttpQueryParameter]
    ] = Optional.Absent,
    scheme: Optional[zio.aws.appmesh.model.HttpScheme] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRouteMatch = {
    import HttpRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
      .builder()
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .optionallyWith(method.map(value => value.unwrap))(_.method)
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .optionallyWith(port.map(value => ListenerPort.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(scheme.map(value => value.unwrap))(_.scheme)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRouteMatch.ReadOnly =
    zio.aws.appmesh.model.HttpRouteMatch.wrap(buildAwsValue())
}
object HttpRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRouteMatch =
      zio.aws.appmesh.model.HttpRouteMatch(
        headers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        method.map(value => value),
        path.map(value => value.asEditable),
        port.map(value => value),
        prefix.map(value => value),
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheme.map(value => value)
      )
    def headers: Optional[List[zio.aws.appmesh.model.HttpRouteHeader.ReadOnly]]
    def method: Optional[zio.aws.appmesh.model.HttpMethod]
    def path: Optional[zio.aws.appmesh.model.HttpPathMatch.ReadOnly]
    def port: Optional[ListenerPort]
    def prefix: Optional[String]
    def queryParameters
        : Optional[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]]
    def scheme: Optional[zio.aws.appmesh.model.HttpScheme]
    def getHeaders: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpRouteHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("headers", headers)
    def getMethod: ZIO[Any, AwsError, zio.aws.appmesh.model.HttpMethod] =
      AwsError.unwrapOptionField("method", method)
    def getPath
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      AwsError.unwrapOptionField("path", path)
    def getPort: ZIO[Any, AwsError, ListenerPort] =
      AwsError.unwrapOptionField("port", port)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpQueryParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getScheme: ZIO[Any, AwsError, zio.aws.appmesh.model.HttpScheme] =
      AwsError.unwrapOptionField("scheme", scheme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ) extends zio.aws.appmesh.model.HttpRouteMatch.ReadOnly {
    override val headers
        : Optional[List[zio.aws.appmesh.model.HttpRouteHeader.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.HttpRouteHeader.wrap(item)
          }.toList
        )
    override val method: Optional[zio.aws.appmesh.model.HttpMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.method())
        .map(value => zio.aws.appmesh.model.HttpMethod.wrap(value))
    override val path: Optional[zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.path())
        .map(value => zio.aws.appmesh.model.HttpPathMatch.wrap(value))
    override val port: Optional[ListenerPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.ListenerPort(value))
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val queryParameters
        : Optional[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.HttpQueryParameter.wrap(item)
          }.toList
        )
    override val scheme: Optional[zio.aws.appmesh.model.HttpScheme] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheme())
        .map(value => zio.aws.appmesh.model.HttpScheme.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ): zio.aws.appmesh.model.HttpRouteMatch.ReadOnly = new Wrapper(impl)
}
