package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVirtualGatewaysResponse(
    nextToken: Optional[String] = Optional.Absent,
    virtualGateways: Iterable[zio.aws.appmesh.model.VirtualGatewayRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse = {
    import ListVirtualGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualGateways(virtualGateways.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly =
    zio.aws.appmesh.model.ListVirtualGatewaysResponse.wrap(buildAwsValue())
}
object ListVirtualGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualGatewaysResponse =
      zio.aws.appmesh.model.ListVirtualGatewaysResponse(
        nextToken.map(value => value),
        virtualGateways.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def virtualGateways: List[zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualGateways: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly
    ]] = ZIO.succeed(virtualGateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse
  ) extends zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val virtualGateways
        : List[zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly] = impl
      .virtualGateways()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.VirtualGatewayRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse
  ): zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
