package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListenerTimeout(
    grpc: Optional[zio.aws.appmesh.model.GrpcTimeout] = Optional.Absent,
    http: Optional[zio.aws.appmesh.model.HttpTimeout] = Optional.Absent,
    http2: Optional[zio.aws.appmesh.model.HttpTimeout] = Optional.Absent,
    tcp: Optional[zio.aws.appmesh.model.TcpTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTimeout = {
    import ListenerTimeout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTimeout
      .builder()
      .optionallyWith(grpc.map(value => value.buildAwsValue()))(_.grpc)
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(http2.map(value => value.buildAwsValue()))(_.http2)
      .optionallyWith(tcp.map(value => value.buildAwsValue()))(_.tcp)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTimeout.ReadOnly =
    zio.aws.appmesh.model.ListenerTimeout.wrap(buildAwsValue())
}
object ListenerTimeout {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTimeout =
      zio.aws.appmesh.model.ListenerTimeout(
        grpc.map(value => value.asEditable),
        http.map(value => value.asEditable),
        http2.map(value => value.asEditable),
        tcp.map(value => value.asEditable)
      )
    def grpc: Optional[zio.aws.appmesh.model.GrpcTimeout.ReadOnly]
    def http: Optional[zio.aws.appmesh.model.HttpTimeout.ReadOnly]
    def http2: Optional[zio.aws.appmesh.model.HttpTimeout.ReadOnly]
    def tcp: Optional[zio.aws.appmesh.model.TcpTimeout.ReadOnly]
    def getGrpc
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      AwsError.unwrapOptionField("grpc", grpc)
    def getHttp
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getHttp2
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("http2", http2)
    def getTcp: ZIO[Any, AwsError, zio.aws.appmesh.model.TcpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("tcp", tcp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ) extends zio.aws.appmesh.model.ListenerTimeout.ReadOnly {
    override val grpc: Optional[zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grpc())
        .map(value => zio.aws.appmesh.model.GrpcTimeout.wrap(value))
    override val http: Optional[zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.http())
        .map(value => zio.aws.appmesh.model.HttpTimeout.wrap(value))
    override val http2: Optional[zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.http2())
        .map(value => zio.aws.appmesh.model.HttpTimeout.wrap(value))
    override val tcp: Optional[zio.aws.appmesh.model.TcpTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tcp())
        .map(value => zio.aws.appmesh.model.TcpTimeout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ): zio.aws.appmesh.model.ListenerTimeout.ReadOnly = new Wrapper(impl)
}
