package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MeshServiceDiscovery(
    ipPreference: Optional[zio.aws.appmesh.model.IpPreference] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery = {
    import MeshServiceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery
      .builder()
      .optionallyWith(ipPreference.map(value => value.unwrap))(_.ipPreference)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MeshServiceDiscovery.ReadOnly =
    zio.aws.appmesh.model.MeshServiceDiscovery.wrap(buildAwsValue())
}
object MeshServiceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MeshServiceDiscovery =
      zio.aws.appmesh.model
        .MeshServiceDiscovery(ipPreference.map(value => value))
    def ipPreference: Optional[zio.aws.appmesh.model.IpPreference]
    def getIpPreference
        : ZIO[Any, AwsError, zio.aws.appmesh.model.IpPreference] =
      AwsError.unwrapOptionField("ipPreference", ipPreference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery
  ) extends zio.aws.appmesh.model.MeshServiceDiscovery.ReadOnly {
    override val ipPreference: Optional[zio.aws.appmesh.model.IpPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPreference())
        .map(value => zio.aws.appmesh.model.IpPreference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery
  ): zio.aws.appmesh.model.MeshServiceDiscovery.ReadOnly = new Wrapper(impl)
}
