package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.SdsSecretName
import scala.jdk.CollectionConverters._
final case class TlsValidationContextSdsTrust(secretName: SdsSecretName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContextSdsTrust = {
    import TlsValidationContextSdsTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextSdsTrust
      .builder()
      .secretName(SdsSecretName.unwrap(secretName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContextSdsTrust.wrap(buildAwsValue())
}
object TlsValidationContextSdsTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextSdsTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContextSdsTrust =
      zio.aws.appmesh.model.TlsValidationContextSdsTrust(secretName)
    def secretName: SdsSecretName
    def getSecretName: ZIO[Any, Nothing, SdsSecretName] =
      ZIO.succeed(secretName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextSdsTrust
  ) extends zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly {
    override val secretName: SdsSecretName =
      zio.aws.appmesh.model.primitives.SdsSecretName(impl.secretName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextSdsTrust
  ): zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly = new Wrapper(
    impl
  )
}
