package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.PortNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VirtualGatewayClientPolicyTls(
    certificate: Optional[
      zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate
    ] = Optional.Absent,
    enforce: Optional[Boolean] = Optional.Absent,
    ports: Optional[Iterable[PortNumber]] = Optional.Absent,
    validation: zio.aws.appmesh.model.VirtualGatewayTlsValidationContext
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicyTls = {
    import VirtualGatewayClientPolicyTls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicyTls
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(enforce.map(value => value: java.lang.Boolean))(_.enforce)
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            PortNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.ports)
      .validation(validation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.wrap(buildAwsValue())
}
object VirtualGatewayClientPolicyTls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicyTls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayClientPolicyTls =
      zio.aws.appmesh.model.VirtualGatewayClientPolicyTls(
        certificate.map(value => value.asEditable),
        enforce.map(value => value),
        ports.map(value => value),
        validation.asEditable
      )
    def certificate: Optional[
      zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly
    ]
    def enforce: Optional[Boolean]
    def ports: Optional[List[PortNumber]]
    def validation
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
    def getEnforce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforce", enforce)
    def getPorts: ZIO[Any, AwsError, List[PortNumber]] =
      AwsError.unwrapOptionField("ports", ports)
    def getValidation: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly
    ] = ZIO.succeed(validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicyTls
  ) extends zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly {
    override val certificate: Optional[
      zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.wrap(value)
      )
    override val enforce: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enforce())
      .map(value => value: Boolean)
    override val ports: Optional[List[PortNumber]] = zio.aws.core.internal
      .optionalFromNullable(impl.ports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.primitives.PortNumber(item)
        }.toList
      )
    override val validation
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContext
        .wrap(impl.validation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicyTls
  ): zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly = new Wrapper(
    impl
  )
}
