package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters._
final case class VirtualGatewayFileAccessLog(
    format: Optional[zio.aws.appmesh.model.LoggingFormat] = Optional.Absent,
    path: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog = {
    import VirtualGatewayFileAccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
      .builder()
      .optionallyWith(format.map(value => value.buildAwsValue()))(_.format)
      .path(FilePath.unwrap(path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayFileAccessLog.wrap(buildAwsValue())
}
object VirtualGatewayFileAccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayFileAccessLog =
      zio.aws.appmesh.model.VirtualGatewayFileAccessLog(
        format.map(value => value.asEditable),
        path
      )
    def format: Optional[zio.aws.appmesh.model.LoggingFormat.ReadOnly]
    def path: FilePath
    def getFormat
        : ZIO[Any, AwsError, zio.aws.appmesh.model.LoggingFormat.ReadOnly] =
      AwsError.unwrapOptionField("format", format)
    def getPath: ZIO[Any, Nothing, FilePath] = ZIO.succeed(path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ) extends zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly {
    override val format
        : Optional[zio.aws.appmesh.model.LoggingFormat.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.appmesh.model.LoggingFormat.wrap(value))
    override val path: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ): zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly = new Wrapper(
    impl
  )
}
