package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.MaxRequests
import scala.jdk.CollectionConverters._
final case class VirtualGatewayGrpcConnectionPool(maxRequests: MaxRequests) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool = {
    import VirtualGatewayGrpcConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool
      .builder()
      .maxRequests(MaxRequests.unwrap(maxRequests): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.wrap(buildAwsValue())
}
object VirtualGatewayGrpcConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool =
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool(maxRequests)
    def maxRequests: MaxRequests
    def getMaxRequests: ZIO[Any, Nothing, MaxRequests] =
      ZIO.succeed(maxRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool
  ) extends zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly {
    override val maxRequests: MaxRequests =
      zio.aws.appmesh.model.primitives.MaxRequests(impl.maxRequests())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool
  ): zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly =
    new Wrapper(impl)
}
