package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VirtualGatewayStatus(
    status: zio.aws.appmesh.model.VirtualGatewayStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus = {
    import VirtualGatewayStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayStatus.wrap(buildAwsValue())
}
object VirtualGatewayStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayStatus =
      zio.aws.appmesh.model.VirtualGatewayStatus(status)
    def status: zio.aws.appmesh.model.VirtualGatewayStatusCode
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewayStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus
  ) extends zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.VirtualGatewayStatusCode =
      zio.aws.appmesh.model.VirtualGatewayStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus
  ): zio.aws.appmesh.model.VirtualGatewayStatus.ReadOnly = new Wrapper(impl)
}
