package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.VirtualGatewaySdsSecretName
import scala.jdk.CollectionConverters._
final case class VirtualGatewayTlsValidationContextSdsTrust(
    secretName: VirtualGatewaySdsSecretName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust = {
    import VirtualGatewayTlsValidationContextSdsTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
      .builder()
      .secretName(
        VirtualGatewaySdsSecretName.unwrap(secretName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContextSdsTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust =
      zio.aws.appmesh.model
        .VirtualGatewayTlsValidationContextSdsTrust(secretName)
    def secretName: VirtualGatewaySdsSecretName
    def getSecretName: ZIO[Any, Nothing, VirtualGatewaySdsSecretName] =
      ZIO.succeed(secretName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly {
    override val secretName: VirtualGatewaySdsSecretName =
      zio.aws.appmesh.model.primitives
        .VirtualGatewaySdsSecretName(impl.secretName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly =
    new Wrapper(impl)
}
