package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DeleteVirtualRouterRequest(
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest = {
    import DeleteVirtualRouterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualRouterRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualRouterRequest.wrap(buildAwsValue())
}
object DeleteVirtualRouterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualRouterRequest =
      zio.aws.appmesh.model.DeleteVirtualRouterRequest(
        meshName,
        meshOwner.map(value => value),
        virtualRouterName
      )
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def virtualRouterName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest
  ) extends zio.aws.appmesh.model.DeleteVirtualRouterRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest
  ): zio.aws.appmesh.model.DeleteVirtualRouterRequest.ReadOnly = new Wrapper(
    impl
  )
}
