package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.GatewayRoutePriority
import scala.jdk.CollectionConverters.*
final case class GatewayRouteSpec(
    grpcRoute: Option[zio.aws.appmesh.model.GrpcGatewayRoute] = None,
    http2Route: Option[zio.aws.appmesh.model.HttpGatewayRoute] = None,
    httpRoute: Option[zio.aws.appmesh.model.HttpGatewayRoute] = None,
    priority: Option[GatewayRoutePriority] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec = {
    import GatewayRouteSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec
      .builder()
      .optionallyWith(grpcRoute.map(value => value.buildAwsValue()))(
        _.grpcRoute
      )
      .optionallyWith(http2Route.map(value => value.buildAwsValue()))(
        _.http2Route
      )
      .optionallyWith(httpRoute.map(value => value.buildAwsValue()))(
        _.httpRoute
      )
      .optionallyWith(
        priority.map(value => GatewayRoutePriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteSpec.wrap(buildAwsValue())
}
object GatewayRouteSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteSpec =
      zio.aws.appmesh.model.GatewayRouteSpec(
        grpcRoute.map(value => value.asEditable),
        http2Route.map(value => value.asEditable),
        httpRoute.map(value => value.asEditable),
        priority.map(value => value)
      )
    def grpcRoute: Option[zio.aws.appmesh.model.GrpcGatewayRoute.ReadOnly]
    def http2Route: Option[zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly]
    def httpRoute: Option[zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly]
    def priority: Option[GatewayRoutePriority]
    def getGrpcRoute
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("grpcRoute", grpcRoute)
    def getHttp2Route
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("http2Route", http2Route)
    def getHttpRoute
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("httpRoute", httpRoute)
    def getPriority: ZIO[Any, AwsError, GatewayRoutePriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec
  ) extends zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly {
    override val grpcRoute
        : Option[zio.aws.appmesh.model.GrpcGatewayRoute.ReadOnly] = scala
      .Option(impl.grpcRoute())
      .map(value => zio.aws.appmesh.model.GrpcGatewayRoute.wrap(value))
    override val http2Route
        : Option[zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly] = scala
      .Option(impl.http2Route())
      .map(value => zio.aws.appmesh.model.HttpGatewayRoute.wrap(value))
    override val httpRoute
        : Option[zio.aws.appmesh.model.HttpGatewayRoute.ReadOnly] = scala
      .Option(impl.httpRoute())
      .map(value => zio.aws.appmesh.model.HttpGatewayRoute.wrap(value))
    override val priority: Option[GatewayRoutePriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.appmesh.model.primitives.GatewayRoutePriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec
  ): zio.aws.appmesh.model.GatewayRouteSpec.ReadOnly = new Wrapper(impl)
}
