package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpGatewayRouteMatch(
    headers: Option[Iterable[zio.aws.appmesh.model.HttpGatewayRouteHeader]] =
      None,
    hostname: Option[zio.aws.appmesh.model.GatewayRouteHostnameMatch] = None,
    method: Option[zio.aws.appmesh.model.HttpMethod] = None,
    path: Option[zio.aws.appmesh.model.HttpPathMatch] = None,
    prefix: Option[String] = None,
    queryParameters: Option[
      Iterable[zio.aws.appmesh.model.HttpQueryParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteMatch = {
    import HttpGatewayRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteMatch
      .builder()
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .optionallyWith(hostname.map(value => value.buildAwsValue()))(_.hostname)
      .optionallyWith(method.map(value => value.unwrap))(_.method)
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRouteMatch.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRouteMatch.wrap(buildAwsValue())
}
object HttpGatewayRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRouteMatch =
      zio.aws.appmesh.model.HttpGatewayRouteMatch(
        headers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostname.map(value => value.asEditable),
        method.map(value => value),
        path.map(value => value.asEditable),
        prefix.map(value => value),
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def headers
        : Option[List[zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly]]
    def hostname
        : Option[zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly]
    def method: Option[zio.aws.appmesh.model.HttpMethod]
    def path: Option[zio.aws.appmesh.model.HttpPathMatch.ReadOnly]
    def prefix: Option[String]
    def queryParameters
        : Option[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]]
    def getHeaders: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("headers", headers)
    def getHostname: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly
    ] = AwsError.unwrapOptionField("hostname", hostname)
    def getMethod: ZIO[Any, AwsError, zio.aws.appmesh.model.HttpMethod] =
      AwsError.unwrapOptionField("method", method)
    def getPath
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      AwsError.unwrapOptionField("path", path)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpQueryParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteMatch
  ) extends zio.aws.appmesh.model.HttpGatewayRouteMatch.ReadOnly {
    override val headers
        : Option[List[zio.aws.appmesh.model.HttpGatewayRouteHeader.ReadOnly]] =
      scala
        .Option(impl.headers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.HttpGatewayRouteHeader.wrap(item)
          }.toList
        )
    override val hostname
        : Option[zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly] =
      scala
        .Option(impl.hostname())
        .map(value =>
          zio.aws.appmesh.model.GatewayRouteHostnameMatch.wrap(value)
        )
    override val method: Option[zio.aws.appmesh.model.HttpMethod] = scala
      .Option(impl.method())
      .map(value => zio.aws.appmesh.model.HttpMethod.wrap(value))
    override val path: Option[zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      scala
        .Option(impl.path())
        .map(value => zio.aws.appmesh.model.HttpPathMatch.wrap(value))
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val queryParameters
        : Option[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]] =
      scala
        .Option(impl.queryParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.HttpQueryParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteMatch
  ): zio.aws.appmesh.model.HttpGatewayRouteMatch.ReadOnly = new Wrapper(impl)
}
