package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{HttpPathRegex, HttpPathExact}
import scala.jdk.CollectionConverters.*
final case class HttpPathMatch(
    exact: Option[HttpPathExact] = None,
    regex: Option[HttpPathRegex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpPathMatch = {
    import HttpPathMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpPathMatch
      .builder()
      .optionallyWith(
        exact.map(value => HttpPathExact.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        regex.map(value => HttpPathRegex.unwrap(value): java.lang.String)
      )(_.regex)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpPathMatch.ReadOnly =
    zio.aws.appmesh.model.HttpPathMatch.wrap(buildAwsValue())
}
object HttpPathMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpPathMatch = zio.aws.appmesh.model
      .HttpPathMatch(exact.map(value => value), regex.map(value => value))
    def exact: Option[HttpPathExact]
    def regex: Option[HttpPathRegex]
    def getExact: ZIO[Any, AwsError, HttpPathExact] =
      AwsError.unwrapOptionField("exact", exact)
    def getRegex: ZIO[Any, AwsError, HttpPathRegex] =
      AwsError.unwrapOptionField("regex", regex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ) extends zio.aws.appmesh.model.HttpPathMatch.ReadOnly {
    override val exact: Option[HttpPathExact] = scala
      .Option(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.HttpPathExact(value))
    override val regex: Option[HttpPathRegex] = scala
      .Option(impl.regex())
      .map(value => zio.aws.appmesh.model.primitives.HttpPathRegex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ): zio.aws.appmesh.model.HttpPathMatch.ReadOnly = new Wrapper(impl)
}
