package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{MaxRetries, HttpRetryPolicyEvent}
import scala.jdk.CollectionConverters.*
final case class HttpRetryPolicy(
    httpRetryEvents: Option[Iterable[HttpRetryPolicyEvent]] = None,
    maxRetries: MaxRetries,
    perRetryTimeout: zio.aws.appmesh.model.Duration,
    tcpRetryEvents: Option[
      Iterable[zio.aws.appmesh.model.TcpRetryPolicyEvent]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy = {
    import HttpRetryPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy
      .builder()
      .optionallyWith(
        httpRetryEvents.map(value =>
          value.map { item =>
            HttpRetryPolicyEvent.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.httpRetryEvents)
      .maxRetries(MaxRetries.unwrap(maxRetries): java.lang.Long)
      .perRetryTimeout(perRetryTimeout.buildAwsValue())
      .optionallyWith(
        tcpRetryEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.tcpRetryEventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly =
    zio.aws.appmesh.model.HttpRetryPolicy.wrap(buildAwsValue())
}
object HttpRetryPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRetryPolicy =
      zio.aws.appmesh.model.HttpRetryPolicy(
        httpRetryEvents.map(value => value),
        maxRetries,
        perRetryTimeout.asEditable,
        tcpRetryEvents.map(value => value)
      )
    def httpRetryEvents: Option[List[HttpRetryPolicyEvent]]
    def maxRetries: MaxRetries
    def perRetryTimeout: zio.aws.appmesh.model.Duration.ReadOnly
    def tcpRetryEvents: Option[List[zio.aws.appmesh.model.TcpRetryPolicyEvent]]
    def getHttpRetryEvents: ZIO[Any, AwsError, List[HttpRetryPolicyEvent]] =
      AwsError.unwrapOptionField("httpRetryEvents", httpRetryEvents)
    def getMaxRetries: ZIO[Any, Nothing, MaxRetries] = ZIO.succeed(maxRetries)
    def getPerRetryTimeout
        : ZIO[Any, Nothing, zio.aws.appmesh.model.Duration.ReadOnly] =
      ZIO.succeed(perRetryTimeout)
    def getTcpRetryEvents
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TcpRetryPolicyEvent]] =
      AwsError.unwrapOptionField("tcpRetryEvents", tcpRetryEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy
  ) extends zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly {
    override val httpRetryEvents: Option[List[HttpRetryPolicyEvent]] = scala
      .Option(impl.httpRetryEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.primitives.HttpRetryPolicyEvent(item)
        }.toList
      )
    override val maxRetries: MaxRetries =
      zio.aws.appmesh.model.primitives.MaxRetries(impl.maxRetries())
    override val perRetryTimeout: zio.aws.appmesh.model.Duration.ReadOnly =
      zio.aws.appmesh.model.Duration.wrap(impl.perRetryTimeout())
    override val tcpRetryEvents
        : Option[List[zio.aws.appmesh.model.TcpRetryPolicyEvent]] = scala
      .Option(impl.tcpRetryEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.TcpRetryPolicyEvent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy
  ): zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly = new Wrapper(impl)
}
