package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListGatewayRoutesLimit
}
import scala.jdk.CollectionConverters.*
final case class ListGatewayRoutesRequest(
    limit: Option[ListGatewayRoutesLimit] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    nextToken: Option[String] = None,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest = {
    import ListGatewayRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListGatewayRoutesLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListGatewayRoutesRequest.ReadOnly =
    zio.aws.appmesh.model.ListGatewayRoutesRequest.wrap(buildAwsValue())
}
object ListGatewayRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListGatewayRoutesRequest =
      zio.aws.appmesh.model.ListGatewayRoutesRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value),
        virtualGatewayName
      )
    def limit: Option[ListGatewayRoutesLimit]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def nextToken: Option[String]
    def virtualGatewayName: ResourceName
    def getLimit: ZIO[Any, AwsError, ListGatewayRoutesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest
  ) extends zio.aws.appmesh.model.ListGatewayRoutesRequest.ReadOnly {
    override val limit: Option[ListGatewayRoutesLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.appmesh.model.primitives.ListGatewayRoutesLimit(value)
      )
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest
  ): zio.aws.appmesh.model.ListGatewayRoutesRequest.ReadOnly = new Wrapper(impl)
}
