package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListenerTimeout(
    grpc: Option[zio.aws.appmesh.model.GrpcTimeout] = None,
    http: Option[zio.aws.appmesh.model.HttpTimeout] = None,
    http2: Option[zio.aws.appmesh.model.HttpTimeout] = None,
    tcp: Option[zio.aws.appmesh.model.TcpTimeout] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTimeout = {
    import ListenerTimeout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTimeout
      .builder()
      .optionallyWith(grpc.map(value => value.buildAwsValue()))(_.grpc)
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(http2.map(value => value.buildAwsValue()))(_.http2)
      .optionallyWith(tcp.map(value => value.buildAwsValue()))(_.tcp)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTimeout.ReadOnly =
    zio.aws.appmesh.model.ListenerTimeout.wrap(buildAwsValue())
}
object ListenerTimeout {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTimeout =
      zio.aws.appmesh.model.ListenerTimeout(
        grpc.map(value => value.asEditable),
        http.map(value => value.asEditable),
        http2.map(value => value.asEditable),
        tcp.map(value => value.asEditable)
      )
    def grpc: Option[zio.aws.appmesh.model.GrpcTimeout.ReadOnly]
    def http: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly]
    def http2: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly]
    def tcp: Option[zio.aws.appmesh.model.TcpTimeout.ReadOnly]
    def getGrpc
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      AwsError.unwrapOptionField("grpc", grpc)
    def getHttp
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getHttp2
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("http2", http2)
    def getTcp: ZIO[Any, AwsError, zio.aws.appmesh.model.TcpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("tcp", tcp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ) extends zio.aws.appmesh.model.ListenerTimeout.ReadOnly {
    override val grpc: Option[zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      scala
        .Option(impl.grpc())
        .map(value => zio.aws.appmesh.model.GrpcTimeout.wrap(value))
    override val http: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      scala
        .Option(impl.http())
        .map(value => zio.aws.appmesh.model.HttpTimeout.wrap(value))
    override val http2: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      scala
        .Option(impl.http2())
        .map(value => zio.aws.appmesh.model.HttpTimeout.wrap(value))
    override val tcp: Option[zio.aws.appmesh.model.TcpTimeout.ReadOnly] = scala
      .Option(impl.tcp())
      .map(value => zio.aws.appmesh.model.TcpTimeout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTimeout
  ): zio.aws.appmesh.model.ListenerTimeout.ReadOnly = new Wrapper(impl)
}
