package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListenerTlsValidationContext(
    subjectAlternativeNames: Option[
      zio.aws.appmesh.model.SubjectAlternativeNames
    ] = None,
    trust: zio.aws.appmesh.model.ListenerTlsValidationContextTrust
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext = {
    import ListenerTlsValidationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext
      .builder()
      .optionallyWith(
        subjectAlternativeNames.map(value => value.buildAwsValue())
      )(_.subjectAlternativeNames)
      .trust(trust.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsValidationContext.wrap(buildAwsValue())
}
object ListenerTlsValidationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsValidationContext =
      zio.aws.appmesh.model.ListenerTlsValidationContext(
        subjectAlternativeNames.map(value => value.asEditable),
        trust.asEditable
      )
    def subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly]
    def trust: zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly
    def getSubjectAlternativeNames: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subjectAlternativeNames",
      subjectAlternativeNames
    )
    def getTrust: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly
    ] = ZIO.succeed(trust)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext
  ) extends zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly {
    override val subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value => zio.aws.appmesh.model.SubjectAlternativeNames.wrap(value))
    override val trust
        : zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly =
      zio.aws.appmesh.model.ListenerTlsValidationContextTrust.wrap(impl.trust())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext
  ): zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly = new Wrapper(
    impl
  )
}
