package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Logging(
    accessLog: Option[zio.aws.appmesh.model.AccessLog] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.appmesh.model.Logging = {
    import Logging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.Logging
      .builder()
      .optionallyWith(accessLog.map(value => value.buildAwsValue()))(
        _.accessLog
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.Logging.ReadOnly =
    zio.aws.appmesh.model.Logging.wrap(buildAwsValue())
}
object Logging {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.Logging] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.Logging =
      zio.aws.appmesh.model.Logging(accessLog.map(value => value.asEditable))
    def accessLog: Option[zio.aws.appmesh.model.AccessLog.ReadOnly]
    def getAccessLog
        : ZIO[Any, AwsError, zio.aws.appmesh.model.AccessLog.ReadOnly] =
      AwsError.unwrapOptionField("accessLog", accessLog)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.Logging
  ) extends zio.aws.appmesh.model.Logging.ReadOnly {
    override val accessLog: Option[zio.aws.appmesh.model.AccessLog.ReadOnly] =
      scala
        .Option(impl.accessLog())
        .map(value => zio.aws.appmesh.model.AccessLog.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.Logging
  ): zio.aws.appmesh.model.Logging.ReadOnly = new Wrapper(impl)
}
