package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MatchRange(end: Long, start: Long) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.MatchRange = {
    import MatchRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MatchRange
      .builder()
      .end(end: java.lang.Long)
      .start(start: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MatchRange.ReadOnly =
    zio.aws.appmesh.model.MatchRange.wrap(buildAwsValue())
}
object MatchRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.MatchRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MatchRange =
      zio.aws.appmesh.model.MatchRange(end, start)
    def end: Long
    def start: Long
    def getEnd: ZIO[Any, Nothing, Long] = ZIO.succeed(end)
    def getStart: ZIO[Any, Nothing, Long] = ZIO.succeed(start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MatchRange
  ) extends zio.aws.appmesh.model.MatchRange.ReadOnly {
    override val end: Long = impl.end(): Long
    override val start: Long = impl.start(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MatchRange
  ): zio.aws.appmesh.model.MatchRange.ReadOnly = new Wrapper(impl)
}
