package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{
  OutlierDetectionMaxServerErrors,
  OutlierDetectionMaxEjectionPercent
}
import scala.jdk.CollectionConverters.*
final case class OutlierDetection(
    baseEjectionDuration: zio.aws.appmesh.model.Duration,
    interval: zio.aws.appmesh.model.Duration,
    maxEjectionPercent: OutlierDetectionMaxEjectionPercent,
    maxServerErrors: OutlierDetectionMaxServerErrors
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.OutlierDetection = {
    import OutlierDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.OutlierDetection
      .builder()
      .baseEjectionDuration(baseEjectionDuration.buildAwsValue())
      .interval(interval.buildAwsValue())
      .maxEjectionPercent(
        OutlierDetectionMaxEjectionPercent.unwrap(maxEjectionPercent): Integer
      )
      .maxServerErrors(
        OutlierDetectionMaxServerErrors.unwrap(maxServerErrors): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.OutlierDetection.ReadOnly =
    zio.aws.appmesh.model.OutlierDetection.wrap(buildAwsValue())
}
object OutlierDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.OutlierDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.OutlierDetection =
      zio.aws.appmesh.model.OutlierDetection(
        baseEjectionDuration.asEditable,
        interval.asEditable,
        maxEjectionPercent,
        maxServerErrors
      )
    def baseEjectionDuration: zio.aws.appmesh.model.Duration.ReadOnly
    def interval: zio.aws.appmesh.model.Duration.ReadOnly
    def maxEjectionPercent: OutlierDetectionMaxEjectionPercent
    def maxServerErrors: OutlierDetectionMaxServerErrors
    def getBaseEjectionDuration
        : ZIO[Any, Nothing, zio.aws.appmesh.model.Duration.ReadOnly] =
      ZIO.succeed(baseEjectionDuration)
    def getInterval
        : ZIO[Any, Nothing, zio.aws.appmesh.model.Duration.ReadOnly] =
      ZIO.succeed(interval)
    def getMaxEjectionPercent
        : ZIO[Any, Nothing, OutlierDetectionMaxEjectionPercent] =
      ZIO.succeed(maxEjectionPercent)
    def getMaxServerErrors: ZIO[Any, Nothing, OutlierDetectionMaxServerErrors] =
      ZIO.succeed(maxServerErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.OutlierDetection
  ) extends zio.aws.appmesh.model.OutlierDetection.ReadOnly {
    override val baseEjectionDuration: zio.aws.appmesh.model.Duration.ReadOnly =
      zio.aws.appmesh.model.Duration.wrap(impl.baseEjectionDuration())
    override val interval: zio.aws.appmesh.model.Duration.ReadOnly =
      zio.aws.appmesh.model.Duration.wrap(impl.interval())
    override val maxEjectionPercent: OutlierDetectionMaxEjectionPercent =
      zio.aws.appmesh.model.primitives
        .OutlierDetectionMaxEjectionPercent(impl.maxEjectionPercent())
    override val maxServerErrors: OutlierDetectionMaxServerErrors =
      zio.aws.appmesh.model.primitives
        .OutlierDetectionMaxServerErrors(impl.maxServerErrors())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.OutlierDetection
  ): zio.aws.appmesh.model.OutlierDetection.ReadOnly = new Wrapper(impl)
}
