package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryParameterMatch(exact: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.QueryParameterMatch = {
    import QueryParameterMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.QueryParameterMatch
      .builder()
      .optionallyWith(exact.map(value => value: java.lang.String))(_.exact)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.QueryParameterMatch.ReadOnly =
    zio.aws.appmesh.model.QueryParameterMatch.wrap(buildAwsValue())
}
object QueryParameterMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.QueryParameterMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.QueryParameterMatch =
      zio.aws.appmesh.model.QueryParameterMatch(exact.map(value => value))
    def exact: Option[String]
    def getExact: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exact", exact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.QueryParameterMatch
  ) extends zio.aws.appmesh.model.QueryParameterMatch.ReadOnly {
    override val exact: Option[String] =
      scala.Option(impl.exact()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.QueryParameterMatch
  ): zio.aws.appmesh.model.QueryParameterMatch.ReadOnly = new Wrapper(impl)
}
