package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TlsValidationContext(
    subjectAlternativeNames: Option[
      zio.aws.appmesh.model.SubjectAlternativeNames
    ] = None,
    trust: zio.aws.appmesh.model.TlsValidationContextTrust
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContext = {
    import TlsValidationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContext
      .builder()
      .optionallyWith(
        subjectAlternativeNames.map(value => value.buildAwsValue())
      )(_.subjectAlternativeNames)
      .trust(trust.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContext.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContext.wrap(buildAwsValue())
}
object TlsValidationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContext =
      zio.aws.appmesh.model.TlsValidationContext(
        subjectAlternativeNames.map(value => value.asEditable),
        trust.asEditable
      )
    def subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly]
    def trust: zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly
    def getSubjectAlternativeNames: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subjectAlternativeNames",
      subjectAlternativeNames
    )
    def getTrust: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly
    ] = ZIO.succeed(trust)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContext
  ) extends zio.aws.appmesh.model.TlsValidationContext.ReadOnly {
    override val subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value => zio.aws.appmesh.model.SubjectAlternativeNames.wrap(value))
    override val trust
        : zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly =
      zio.aws.appmesh.model.TlsValidationContextTrust.wrap(impl.trust())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContext
  ): zio.aws.appmesh.model.TlsValidationContext.ReadOnly = new Wrapper(impl)
}
