package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class UpdateVirtualGatewayRequest(
    clientToken: Option[String] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    spec: zio.aws.appmesh.model.VirtualGatewaySpec,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest = {
    import UpdateVirtualGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualGatewayRequest.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualGatewayRequest.wrap(buildAwsValue())
}
object UpdateVirtualGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualGatewayRequest =
      zio.aws.appmesh.model.UpdateVirtualGatewayRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        virtualGatewayName
      )
    def clientToken: Option[String]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def spec: zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly
    def virtualGatewayName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly] =
      ZIO.succeed(spec)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest
  ) extends zio.aws.appmesh.model.UpdateVirtualGatewayRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewaySpec.wrap(impl.spec())
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest
  ): zio.aws.appmesh.model.UpdateVirtualGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
