package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class VirtualNodeServiceProvider(virtualNodeName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider = {
    import VirtualNodeServiceProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider
      .builder()
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeServiceProvider.wrap(buildAwsValue())
}
object VirtualNodeServiceProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeServiceProvider =
      zio.aws.appmesh.model.VirtualNodeServiceProvider(virtualNodeName)
    def virtualNodeName: ResourceName
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider
  ) extends zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly {
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider
  ): zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly = new Wrapper(
    impl
  )
}
