package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class VirtualRouterData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.VirtualRouterSpec,
    status: zio.aws.appmesh.model.VirtualRouterStatus,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterData = {
    import VirtualRouterData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualRouterData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualRouterData.ReadOnly =
    zio.aws.appmesh.model.VirtualRouterData.wrap(buildAwsValue())
}
object VirtualRouterData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualRouterData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualRouterData =
      zio.aws.appmesh.model.VirtualRouterData(
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable,
        virtualRouterName
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly
    def status: zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly
    def virtualRouterName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly
    ] = ZIO.succeed(status)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterData
  ) extends zio.aws.appmesh.model.VirtualRouterData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterStatus.wrap(impl.status())
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterData
  ): zio.aws.appmesh.model.VirtualRouterData.ReadOnly = new Wrapper(impl)
}
