package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VirtualServiceSpec(
    provider: Option[zio.aws.appmesh.model.VirtualServiceProvider] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec = {
    import VirtualServiceSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec
      .builder()
      .optionallyWith(provider.map(value => value.buildAwsValue()))(_.provider)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceSpec.wrap(buildAwsValue())
}
object VirtualServiceSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceSpec =
      zio.aws.appmesh.model
        .VirtualServiceSpec(provider.map(value => value.asEditable))
    def provider: Option[zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly]
    def getProvider: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly
    ] = AwsError.unwrapOptionField("provider", provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec
  ) extends zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly {
    override val provider
        : Option[zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly] = scala
      .Option(impl.provider())
      .map(value => zio.aws.appmesh.model.VirtualServiceProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec
  ): zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly = new Wrapper(impl)
}
