package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.AwsCloudMapName
import scala.jdk.CollectionConverters.*
final case class AwsCloudMapServiceDiscovery(
    attributes: Optional[
      Iterable[zio.aws.appmesh.model.AwsCloudMapInstanceAttribute]
    ] = Optional.Absent,
    ipPreference: Optional[zio.aws.appmesh.model.IpPreference] =
      Optional.Absent,
    namespaceName: AwsCloudMapName,
    serviceName: AwsCloudMapName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery = {
    import AwsCloudMapServiceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(ipPreference.map(value => value.unwrap))(_.ipPreference)
      .namespaceName(AwsCloudMapName.unwrap(namespaceName): java.lang.String)
      .serviceName(AwsCloudMapName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly =
    zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.wrap(buildAwsValue())
}
object AwsCloudMapServiceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.AwsCloudMapServiceDiscovery =
      zio.aws.appmesh.model.AwsCloudMapServiceDiscovery(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipPreference.map(value => value),
        namespaceName,
        serviceName
      )
    def attributes: Optional[
      List[zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly]
    ]
    def ipPreference: Optional[zio.aws.appmesh.model.IpPreference]
    def namespaceName: AwsCloudMapName
    def serviceName: AwsCloudMapName
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getIpPreference
        : ZIO[Any, AwsError, zio.aws.appmesh.model.IpPreference] =
      AwsError.unwrapOptionField("ipPreference", ipPreference)
    def getNamespaceName: ZIO[Any, Nothing, AwsCloudMapName] =
      ZIO.succeed(namespaceName)
    def getServiceName: ZIO[Any, Nothing, AwsCloudMapName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery
  ) extends zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly {
    override val attributes: Optional[
      List[zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.wrap(item)
        }.toList
      )
    override val ipPreference: Optional[zio.aws.appmesh.model.IpPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPreference())
        .map(value => zio.aws.appmesh.model.IpPreference.wrap(value))
    override val namespaceName: AwsCloudMapName =
      zio.aws.appmesh.model.primitives.AwsCloudMapName(impl.namespaceName())
    override val serviceName: AwsCloudMapName =
      zio.aws.appmesh.model.primitives.AwsCloudMapName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery
  ): zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly = new Wrapper(
    impl
  )
}
