package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateVirtualServiceResponse(
    virtualService: zio.aws.appmesh.model.VirtualServiceData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse = {
    import CreateVirtualServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse
      .builder()
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly =
    zio.aws.appmesh.model.CreateVirtualServiceResponse.wrap(buildAwsValue())
}
object CreateVirtualServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateVirtualServiceResponse =
      zio.aws.appmesh.model
        .CreateVirtualServiceResponse(virtualService.asEditable)
    def virtualService: zio.aws.appmesh.model.VirtualServiceData.ReadOnly
    def getVirtualService
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceData.ReadOnly] =
      ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse
  ) extends zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly {
    override val virtualService
        : zio.aws.appmesh.model.VirtualServiceData.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceData.wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse
  ): zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly = new Wrapper(
    impl
  )
}
