package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMeshResponse(mesh: zio.aws.appmesh.model.MeshData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse = {
    import DeleteMeshResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse
      .builder()
      .mesh(mesh.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly =
    zio.aws.appmesh.model.DeleteMeshResponse.wrap(buildAwsValue())
}
object DeleteMeshResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteMeshResponse =
      zio.aws.appmesh.model.DeleteMeshResponse(mesh.asEditable)
    def mesh: zio.aws.appmesh.model.MeshData.ReadOnly
    def getMesh: ZIO[Any, Nothing, zio.aws.appmesh.model.MeshData.ReadOnly] =
      ZIO.succeed(mesh)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse
  ) extends zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly {
    override val mesh: zio.aws.appmesh.model.MeshData.ReadOnly =
      zio.aws.appmesh.model.MeshData.wrap(impl.mesh())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse
  ): zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly = new Wrapper(impl)
}
