package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{ServiceName, AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DescribeVirtualServiceRequest(
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest = {
    import DescribeVirtualServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeVirtualServiceRequest.ReadOnly =
    zio.aws.appmesh.model.DescribeVirtualServiceRequest.wrap(buildAwsValue())
}
object DescribeVirtualServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeVirtualServiceRequest =
      zio.aws.appmesh.model.DescribeVirtualServiceRequest(
        meshName,
        meshOwner.map(value => value),
        virtualServiceName
      )
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def virtualServiceName: ServiceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest
  ) extends zio.aws.appmesh.model.DescribeVirtualServiceRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest
  ): zio.aws.appmesh.model.DescribeVirtualServiceRequest.ReadOnly = new Wrapper(
    impl
  )
}
