package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait DurationUnit {
  def unwrap: software.amazon.awssdk.services.appmesh.model.DurationUnit
}
object DurationUnit {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.DurationUnit
  ): zio.aws.appmesh.model.DurationUnit = value match {
    case software.amazon.awssdk.services.appmesh.model.DurationUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.DurationUnit.S =>
      val r = s
      r
    case software.amazon.awssdk.services.appmesh.model.DurationUnit.MS =>
      val r = ms
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.DurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DurationUnit =
      software.amazon.awssdk.services.appmesh.model.DurationUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object s extends zio.aws.appmesh.model.DurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DurationUnit =
      software.amazon.awssdk.services.appmesh.model.DurationUnit.S
  }
  case object ms extends zio.aws.appmesh.model.DurationUnit {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DurationUnit =
      software.amazon.awssdk.services.appmesh.model.DurationUnit.MS
  }
}
