package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class GatewayRouteVirtualService(virtualServiceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteVirtualService = {
    import GatewayRouteVirtualService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteVirtualService
      .builder()
      .virtualServiceName(
        ResourceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteVirtualService.wrap(buildAwsValue())
}
object GatewayRouteVirtualService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteVirtualService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteVirtualService =
      zio.aws.appmesh.model.GatewayRouteVirtualService(virtualServiceName)
    def virtualServiceName: ResourceName
    def getVirtualServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteVirtualService
  ) extends zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly {
    override val virtualServiceName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteVirtualService
  ): zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly = new Wrapper(
    impl
  )
}
