package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GrpcRouteAction(
    weightedTargets: Iterable[zio.aws.appmesh.model.WeightedTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcRouteAction = {
    import GrpcRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcRouteAction
      .builder()
      .weightedTargets(weightedTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcRouteAction.ReadOnly =
    zio.aws.appmesh.model.GrpcRouteAction.wrap(buildAwsValue())
}
object GrpcRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcRouteAction =
      zio.aws.appmesh.model.GrpcRouteAction(weightedTargets.map { item =>
        item.asEditable
      })
    def weightedTargets: List[zio.aws.appmesh.model.WeightedTarget.ReadOnly]
    def getWeightedTargets: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.WeightedTarget.ReadOnly
    ]] = ZIO.succeed(weightedTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRouteAction
  ) extends zio.aws.appmesh.model.GrpcRouteAction.ReadOnly {
    override val weightedTargets
        : List[zio.aws.appmesh.model.WeightedTarget.ReadOnly] = impl
      .weightedTargets()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.WeightedTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRouteAction
  ): zio.aws.appmesh.model.GrpcRouteAction.ReadOnly = new Wrapper(impl)
}
