package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.HttpGatewayRoutePrefix
import scala.jdk.CollectionConverters.*
final case class HttpGatewayRoutePrefixRewrite(
    defaultPrefix: Optional[zio.aws.appmesh.model.DefaultGatewayRouteRewrite] =
      Optional.Absent,
    value: Optional[HttpGatewayRoutePrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePrefixRewrite = {
    import HttpGatewayRoutePrefixRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePrefixRewrite
      .builder()
      .optionallyWith(defaultPrefix.map(value => value.unwrap))(_.defaultPrefix)
      .optionallyWith(
        value.map(value =>
          HttpGatewayRoutePrefix.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.wrap(buildAwsValue())
}
object HttpGatewayRoutePrefixRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePrefixRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite =
      zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite(
        defaultPrefix.map(value => value),
        value.map(value => value)
      )
    def defaultPrefix
        : Optional[zio.aws.appmesh.model.DefaultGatewayRouteRewrite]
    def value: Optional[HttpGatewayRoutePrefix]
    def getDefaultPrefix
        : ZIO[Any, AwsError, zio.aws.appmesh.model.DefaultGatewayRouteRewrite] =
      AwsError.unwrapOptionField("defaultPrefix", defaultPrefix)
    def getValue: ZIO[Any, AwsError, HttpGatewayRoutePrefix] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePrefixRewrite
  ) extends zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly {
    override val defaultPrefix
        : Optional[zio.aws.appmesh.model.DefaultGatewayRouteRewrite] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultPrefix())
        .map(value =>
          zio.aws.appmesh.model.DefaultGatewayRouteRewrite.wrap(value)
        )
    override val value: Optional[HttpGatewayRoutePrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.appmesh.model.primitives.HttpGatewayRoutePrefix(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePrefixRewrite
  ): zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly = new Wrapper(
    impl
  )
}
