package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.QueryParameterName
import scala.jdk.CollectionConverters.*
final case class HttpQueryParameter(
    `match`: Optional[zio.aws.appmesh.model.QueryParameterMatch] =
      Optional.Absent,
    name: QueryParameterName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpQueryParameter = {
    import HttpQueryParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpQueryParameter
      .builder()
      .optionallyWith(`match`.map(value => value.buildAwsValue()))(_.`match`)
      .name(QueryParameterName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpQueryParameter.ReadOnly =
    zio.aws.appmesh.model.HttpQueryParameter.wrap(buildAwsValue())
}
object HttpQueryParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpQueryParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpQueryParameter =
      zio.aws.appmesh.model
        .HttpQueryParameter(`match`.map(value => value.asEditable), name)
    def `match`: Optional[zio.aws.appmesh.model.QueryParameterMatch.ReadOnly]
    def name: QueryParameterName
    def getMatch: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.QueryParameterMatch.ReadOnly
    ] = AwsError.unwrapOptionField("match", `match`)
    def getName: ZIO[Any, Nothing, QueryParameterName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpQueryParameter
  ) extends zio.aws.appmesh.model.HttpQueryParameter.ReadOnly {
    override val `match`
        : Optional[zio.aws.appmesh.model.QueryParameterMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`match`())
        .map(value => zio.aws.appmesh.model.QueryParameterMatch.wrap(value))
    override val name: QueryParameterName =
      zio.aws.appmesh.model.primitives.QueryParameterName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpQueryParameter
  ): zio.aws.appmesh.model.HttpQueryParameter.ReadOnly = new Wrapper(impl)
}
