package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    nextToken: Optional[String] = Optional.Absent,
    tags: Iterable[zio.aws.appmesh.model.TagRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.appmesh.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListTagsForResourceResponse =
      zio.aws.appmesh.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def tags: List[zio.aws.appmesh.model.TagRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse
  ) extends zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val tags: List[zio.aws.appmesh.model.TagRef.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.TagRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse
  ): zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
