package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVirtualRoutersResponse(
    nextToken: Optional[String] = Optional.Absent,
    virtualRouters: Iterable[zio.aws.appmesh.model.VirtualRouterRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse = {
    import ListVirtualRoutersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualRouters(virtualRouters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly =
    zio.aws.appmesh.model.ListVirtualRoutersResponse.wrap(buildAwsValue())
}
object ListVirtualRoutersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualRoutersResponse =
      zio.aws.appmesh.model.ListVirtualRoutersResponse(
        nextToken.map(value => value),
        virtualRouters.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def virtualRouters: List[zio.aws.appmesh.model.VirtualRouterRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualRouters: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.VirtualRouterRef.ReadOnly
    ]] = ZIO.succeed(virtualRouters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse
  ) extends zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val virtualRouters
        : List[zio.aws.appmesh.model.VirtualRouterRef.ReadOnly] = impl
      .virtualRouters()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.VirtualRouterRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse
  ): zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly = new Wrapper(
    impl
  )
}
