package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MeshStatus(
    status: Optional[zio.aws.appmesh.model.MeshStatusCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.MeshStatus = {
    import MeshStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MeshStatus
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MeshStatus.ReadOnly =
    zio.aws.appmesh.model.MeshStatus.wrap(buildAwsValue())
}
object MeshStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.MeshStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MeshStatus =
      zio.aws.appmesh.model.MeshStatus(status.map(value => value))
    def status: Optional[zio.aws.appmesh.model.MeshStatusCode]
    def getStatus: ZIO[Any, AwsError, zio.aws.appmesh.model.MeshStatusCode] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MeshStatus
  ) extends zio.aws.appmesh.model.MeshStatus.ReadOnly {
    override val status: Optional[zio.aws.appmesh.model.MeshStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.appmesh.model.MeshStatusCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MeshStatus
  ): zio.aws.appmesh.model.MeshStatus.ReadOnly = new Wrapper(impl)
}
