package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait PortProtocol {
  def unwrap: software.amazon.awssdk.services.appmesh.model.PortProtocol
}
object PortProtocol {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.PortProtocol
  ): zio.aws.appmesh.model.PortProtocol = value match {
    case software.amazon.awssdk.services.appmesh.model.PortProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.PortProtocol.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.appmesh.model.PortProtocol.TCP =>
      val r = tcp
      r
    case software.amazon.awssdk.services.appmesh.model.PortProtocol.HTTP2 =>
      val r = http2
      r
    case software.amazon.awssdk.services.appmesh.model.PortProtocol.GRPC =>
      val r = grpc
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.PortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.PortProtocol =
      software.amazon.awssdk.services.appmesh.model.PortProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.appmesh.model.PortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.PortProtocol =
      software.amazon.awssdk.services.appmesh.model.PortProtocol.HTTP
  }
  case object tcp extends zio.aws.appmesh.model.PortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.PortProtocol =
      software.amazon.awssdk.services.appmesh.model.PortProtocol.TCP
  }
  case object http2 extends zio.aws.appmesh.model.PortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.PortProtocol =
      software.amazon.awssdk.services.appmesh.model.PortProtocol.HTTP2
  }
  case object grpc extends zio.aws.appmesh.model.PortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.PortProtocol =
      software.amazon.awssdk.services.appmesh.model.PortProtocol.GRPC
  }
}
