package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class RouteData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    routeName: ResourceName,
    spec: zio.aws.appmesh.model.RouteSpec,
    status: zio.aws.appmesh.model.RouteStatus,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.RouteData = {
    import RouteData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.RouteData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .routeName(ResourceName.unwrap(routeName): java.lang.String)
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.RouteData.ReadOnly =
    zio.aws.appmesh.model.RouteData.wrap(buildAwsValue())
}
object RouteData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.RouteData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.RouteData =
      zio.aws.appmesh.model.RouteData(
        meshName,
        metadata.asEditable,
        routeName,
        spec.asEditable,
        status.asEditable,
        virtualRouterName
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def routeName: ResourceName
    def spec: zio.aws.appmesh.model.RouteSpec.ReadOnly
    def status: zio.aws.appmesh.model.RouteStatus.ReadOnly
    def virtualRouterName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getRouteName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(routeName)
    def getSpec: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.RouteStatus.ReadOnly] =
      ZIO.succeed(status)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.RouteData
  ) extends zio.aws.appmesh.model.RouteData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val routeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.routeName())
    override val spec: zio.aws.appmesh.model.RouteSpec.ReadOnly =
      zio.aws.appmesh.model.RouteSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.RouteStatus.ReadOnly =
      zio.aws.appmesh.model.RouteStatus.wrap(impl.status())
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.RouteData
  ): zio.aws.appmesh.model.RouteData.ReadOnly = new Wrapper(impl)
}
