package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayClientPolicy(
    tls: Optional[zio.aws.appmesh.model.VirtualGatewayClientPolicyTls] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicy = {
    import VirtualGatewayClientPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicy
      .builder()
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayClientPolicy.wrap(buildAwsValue())
}
object VirtualGatewayClientPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayClientPolicy =
      zio.aws.appmesh.model
        .VirtualGatewayClientPolicy(tls.map(value => value.asEditable))
    def tls
        : Optional[zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly]
    def getTls: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly
    ] = AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicy
  ) extends zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly {
    override val tls: Optional[
      zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tls())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayClientPolicyTls.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientPolicy
  ): zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly = new Wrapper(
    impl
  )
}
