package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.MaxRequests
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayHttp2ConnectionPool(maxRequests: MaxRequests) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool = {
    import VirtualGatewayHttp2ConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool
      .builder()
      .maxRequests(MaxRequests.unwrap(maxRequests): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool
      .wrap(buildAwsValue())
}
object VirtualGatewayHttp2ConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool =
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool(maxRequests)
    def maxRequests: MaxRequests
    def getMaxRequests: ZIO[Any, Nothing, MaxRequests] =
      ZIO.succeed(maxRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool
  ) extends zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly {
    override val maxRequests: MaxRequests =
      zio.aws.appmesh.model.primitives.MaxRequests(impl.maxRequests())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool
  ): zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly =
    new Wrapper(impl)
}
