package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{MaxPendingRequests, MaxConnections}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayHttpConnectionPool(
    maxConnections: MaxConnections,
    maxPendingRequests: Optional[MaxPendingRequests] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool = {
    import VirtualGatewayHttpConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool
      .builder()
      .maxConnections(MaxConnections.unwrap(maxConnections): Integer)
      .optionallyWith(
        maxPendingRequests.map(value =>
          MaxPendingRequests.unwrap(value): Integer
        )
      )(_.maxPendingRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.wrap(buildAwsValue())
}
object VirtualGatewayHttpConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool =
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool(
        maxConnections,
        maxPendingRequests.map(value => value)
      )
    def maxConnections: MaxConnections
    def maxPendingRequests: Optional[MaxPendingRequests]
    def getMaxConnections: ZIO[Any, Nothing, MaxConnections] =
      ZIO.succeed(maxConnections)
    def getMaxPendingRequests: ZIO[Any, AwsError, MaxPendingRequests] =
      AwsError.unwrapOptionField("maxPendingRequests", maxPendingRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool
  ) extends zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly {
    override val maxConnections: MaxConnections =
      zio.aws.appmesh.model.primitives.MaxConnections(impl.maxConnections())
    override val maxPendingRequests: Optional[MaxPendingRequests] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPendingRequests())
        .map(value =>
          zio.aws.appmesh.model.primitives.MaxPendingRequests(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool
  ): zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly =
    new Wrapper(impl)
}
