package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTlsAcmCertificate(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate = {
    import VirtualGatewayListenerTlsAcmCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsAcmCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate =
      zio.aws.appmesh.model
        .VirtualGatewayListenerTlsAcmCertificate(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.appmesh.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly =
    new Wrapper(impl)
}
