package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait VirtualGatewayStatusCode {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode
}
object VirtualGatewayStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode
  ): zio.aws.appmesh.model.VirtualGatewayStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.VirtualGatewayStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.VirtualGatewayStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.VirtualGatewayStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.VirtualGatewayStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatusCode.DELETED
  }
}
