package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayTlsValidationContextAcmTrust(
    certificateAuthorityArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust = {
    import VirtualGatewayTlsValidationContextAcmTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
      .builder()
      .certificateAuthorityArns(certificateAuthorityArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContextAcmTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust =
      zio.aws.appmesh.model
        .VirtualGatewayTlsValidationContextAcmTrust(certificateAuthorityArns)
    def certificateAuthorityArns: List[Arn]
    def getCertificateAuthorityArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(certificateAuthorityArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly {
    override val certificateAuthorityArns: List[Arn] = impl
      .certificateAuthorityArns()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly =
    new Wrapper(impl)
}
